varying vec2 		texcoord;

uniform sampler2D 	dif0,
					bmp0;
uniform vec2		fresnel0,
					spec0;
uniform vec4		dcolor0,
					scolor0;
uniform vec2		dscale0,
					bscale0;
uniform float 		scatterlevel;
	
#ifdef SPECULAR

	uniform sampler2D 	smask;
	uniform vec2		SScale;
	
#endif

#ifdef ALPHATEST

	//uniform sampler2D	amask;
	varying float 		distance;
	uniform float 		alphalevel;
	
#endif

#ifdef PSYSTEM

	varying float 	life;
	varying float	cosa,
					sina;
#else

	#ifdef BSET

		varying vec4 pnormal;
		varying vec3 pcolor;

	#else
	
		varying vec3		eye0,
							eye1,
							eye2;
	#endif
		
#endif
	
					


#ifdef LAYER1
	uniform sampler2D 	lmask;
	uniform sampler2D 	dif1,
						bmp1;
	uniform vec2		fresnel1,
						spec1;
	uniform vec4		dcolor1,
						scolor1;
	uniform vec2		dscale1,
						bscale1;
	#ifdef LAYER2
		uniform sampler2D 	dif2,
							bmp2;
		uniform vec2		fresnel2,
							spec2;
		uniform vec4		dcolor2,
							scolor2;
		uniform vec2		dscale2,
							bscale2;					
							
		#ifdef LAYER3
			uniform sampler2D 	dif3,
								bmp3;
			uniform vec2		fresnel3,
								spec3;
			uniform vec4		dcolor3,
								scolor3;
			uniform vec2		dscale3,
								bscale3;
		#endif

	#endif

#endif


#ifdef COLORMAP

	uniform sampler2D	cmask;
	
#endif

varying vec4 		curpos,pos,prev;
uniform float		vScale;

void main()
{

vec4 	fdcolor,
		fbcolor;
vec3	fnormal;
vec2	fspec,
		ffresnel;
		
fdcolor=texture2D(dif0,texcoord.st*dscale0)*dcolor0;

#ifdef ALPHATEST

	float alpha=fdcolor.a;
//	if(alpha<alphalevel)
	//	return;
	
#endif

fbcolor=texture2D(bmp0,texcoord.st*bscale0);
fnormal=fbcolor.xyz*2.0-1.0;
fspec.x=spec0.x;
fspec.y=spec0.y*fbcolor.a;
ffresnel.x=fresnel0.x;
ffresnel.y=fresnel0.y*fbcolor.a;


#ifdef LAYER1

	vec3 	mask=texture2D(lmask,texcoord.st).rgb,
			compMask=vec3(1.0,1.0,1.0)-mask;
		
	fdcolor=texture2D(dif1,texcoord.st*dscale1)*dcolor1*mask.r + (compMask.r)*fdcolor;	
	fbcolor=texture2D(bmp1,texcoord.st*bscale1);
	fnormal=(fbcolor.xyz*2.0-1.0)*mask.r + (compMask.r)*fnormal;
	normalize(fnormal);
	fspec.x=spec1.x*mask.r + (compMask.r)*fspec.x;
	fspec.y=spec1.y*fbcolor.a*mask.r + (compMask.r)*fspec.y;
	ffresnel.x=fresnel1.x*mask.r + (compMask.r)*ffresnel.x;
	ffresnel.y=fresnel1.y*fbcolor.a*mask.r + (compMask.r)*ffresnel.y;
	
	#ifdef LAYER2
	
		fdcolor=texture2D(dif2,texcoord.st*dscale2)*dcolor2*mask.g + (compMask.g)*fdcolor;	
		fbcolor=texture2D(bmp2,texcoord.st*bscale2);
		fnormal=(fbcolor.xyz*2.0-1.0)*mask.g + (compMask.g)*fnormal;
		normalize(fnormal);
		fspec.x=spec2.x*mask.g + (compMask.g)*fspec.x;
		fspec.y=spec2.y*fbcolor.a*mask.g + (compMask.g)*fspec.y;
		ffresnel.x=fresnel2.x*mask.g + (compMask.g)*ffresnel.x;
		ffresnel.y=fresnel2.y*fbcolor.a*mask.g + (compMask.g)*ffresnel.y;
		
		#ifdef LAYER3
		
			fdcolor=texture2D(dif3,texcoord.st*dscale3)*dcolor3*mask.b + (compMask.b)*fdcolor;	
			fbcolor=texture2D(bmp3,texcoord.st*bscale3);
			fnormal=(fbcolor.xyz*2.0-1.0)*mask.b + (compMask.b)*fnormal;
			normalize(fnormal);
			fspec.x=spec3.x*mask.b + (compMask.b)*fspec.x;
			fspec.y=spec3.y*fbcolor.a*mask.b + (compMask.b)*fspec.y;
			ffresnel.x=fresnel3.x*mask.b + (compMask.b)*ffresnel.x;
			ffresnel.y=fresnel3.y*fbcolor.a*mask.b + (compMask.b)*ffresnel.y;
			
		#endif

	#endif

#endif

	
	// color
#ifdef ALPHATEST

	fdcolor.a=alpha;
	
#endif

#ifdef COLORMAP

	fdcolor.rgb*=texture2D(cmask,texcoord.st).rgb;
	
#endif

	gl_FragData[0]=fdcolor;
	
	#ifdef ALPHATEST
		
			gl_FragData[0].a = alpha*distance;
			
	#endif
 
	#ifdef PSYSTEM
	
		//gl_FragData[0].a = alpha*distance;
		//gl_FragData[2].xyz=fnormal;
		
		gl_FragData[2].x=(fnormal.x*cosa)+(fnormal.y*sina);
		gl_FragData[2].y=(fnormal.x*sina)-(fnormal.y*cosa);
		gl_FragData[2].z=fnormal.z;
		
		#ifdef ALPHATEST
		
			gl_FragData[0].a = gl_FragData[0].a*life;
			
		#endif

	#else
	
		#ifdef BSET
		
		//	gl_FragData[0].a = alpha*distance;
			gl_FragData[0].xyz *= pcolor;
			gl_FragData[2].xyz=pnormal.xyz;//fnormal;
		
		#else
	
			// normal
			gl_FragData[2].x=dot(fnormal,eye0);
			gl_FragData[2].y=dot(fnormal,eye1);
			gl_FragData[2].z=dot(fnormal,eye2);
		
		#endif
		
	#endif
	
	#ifdef SPECULAR
	
		vec3 specColor=texture2D(smask,texcoord.st*SScale).rgb;
		fspec.y*=specColor;
		ffresnel.y*=specColor;
	
	#endif
	
	// material params
	gl_FragData[3].r=fspec.x;
	gl_FragData[3].g=fspec.y;
	gl_FragData[3].b=ffresnel.x;
	gl_FragData[3].a=ffresnel.y;
	
	// pos
	vec2 vel=((curpos.xy/curpos.w)-(prev.xy/prev.w))*0.05*vScale;
	gl_FragData[1].xy = vel;
	gl_FragData[1].z = pos.z;
	
	// scatter
	gl_FragData[1].a=scatterlevel;
}
